#!/bin/bash

# We strongly recomend to not just run this script, but to run this on a cluster with multiple GPUs and adapt the script to for example run 1 defense on 1 GPU.

task_name=tab10 #add your task name
defense=('CRDR' 'CRDR')
param=('quality:0.0 beta:5.12' 'quality:0.0 beta:0.0')
type='--attack_through'
eps='4/255 8/255 16/255'
attack='PGD' 
attack_steps=10
model=('ResNet50' 'Vit')
output='results/tab_10/'
exp_names=(CRDR_HR CRDR_LR)
mkdir -p $output

start_time=$(date +%s)
echo "Running task $task_name with defense: $defense, param: $param, type: $type, eps: $eps"
echo "GPU & CUDA info"
nvcc --version
nvidia-smi
echo "=============================================================="
source /conda.sh #path to your conda.sh
conda activate #add your conda environment

for i in {0..1}
do
    for m in "${model[@]}"
    do
        for b in {0,0.16,0.32,0.64,1.28,2.56,5.12}
        do
            python run_experiment.py \
                --epsilons $eps \
                --attack=$attack \
                --attack_steps=$attack_steps  \
                --output=$output'_'$m'_'"${exp_names[$i]}"'_'$b'_' \
                --save_config \
                --model_attack=$m \
                --defense="${defense[$i]}" \
                --defense_param "${param[$i]}" \
                --attack_model_param "quality:0.0 beta:$b" \
                --get_baseline \
                --dataset=imagenet \ 
                --batch_size=16 \
                $type
        done
    done
done

end_time=$(date +%s)
execution_time=$((end_time - start_time))

echo "Execution time: $execution_time seconds"
echo "finished"